#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <pthread.h>

#define N_VOZILA 10

pthread_mutex_t mutexMost = PTHREAD_MUTEX_INITIALIZER; // pise most jer je krace od nadvoznjak
pthread_cond_t condMost = PTHREAD_COND_INITIALIZER;

int brojAutomobila = 0;
int indAutobus = 0;
int indKamion = 0;

int brojVozilaNaMostu = 0;

int smerNaMostu = -1; // sever = 0, jug = 1, neodredjen = -1

void *prelazak(void *arg){
    long id = (long) arg;

    int mojSmer = rand() % 2;
    int tipVozila = rand() % 3;

    sleep((rand() % 5) + 1);

    pthread_mutex_lock(&mutexMost);
    {
        if(tipVozila == 0){

            printf("Vozilo %ld tipa AUTOMOBIL je doslo do nadvoznjaka sa %s strane\n", id, mojSmer ? "severne" : "juzne");

            while(indKamion == 1 || (brojVozilaNaMostu > 0 && mojSmer != smerNaMostu)){
                pthread_cond_wait(&condMost, &mutexMost);
            }

            brojVozilaNaMostu++;
            brojAutomobila++;
            smerNaMostu = mojSmer;

        } else if(tipVozila == 1){

            printf("Vozilo %ld tipa AUTOBUS je doslo do nadvoznjaka sa %s strane\n", id, mojSmer ? "severne" : "juzne");

            while(indKamion == 1 || (smerNaMostu != mojSmer && brojVozilaNaMostu > 0) || (smerNaMostu == mojSmer && indAutobus == 1)){
                pthread_cond_wait(&condMost, &mutexMost);
            }

            brojVozilaNaMostu++;
            smerNaMostu = mojSmer;

            if(indAutobus == 0){
                indAutobus = 1;
            }

        } else if(tipVozila == 2){

            printf("Vozilo %ld tipa KAMION je doslo do nadvoznjaka sa %s strane\n", id, mojSmer ? "severne" : "juzne");

            while(indKamion == 1 || (brojVozilaNaMostu > 0 && mojSmer != smerNaMostu)){
                pthread_cond_wait(&condMost, &mutexMost);
            }

            brojVozilaNaMostu++;
            smerNaMostu = mojSmer;

            if(indKamion == 0){
                indKamion = 1;
            }
            
        } else {

            printf("NIT %ld IMA POGRESAN TIP VOZILA (EXIT)\n", id);

            pthread_mutex_unlock(&mutexMost);

            return NULL;
        }

        printf("Vozilo %ld krece da prelazi most\n", id);
    }
    pthread_mutex_unlock(&mutexMost);

    sleep((rand() % 5) + 1);

    pthread_mutex_lock(&mutexMost);
    {
        brojVozilaNaMostu--;

        if(tipVozila == 0){

            brojAutomobila--;

            printf("Vozilo %ld tipa AUTOMOBIL je preslo nadvoznjak sa %s strane\n", id, mojSmer ? "severne" : "juzne");

        } else if(tipVozila == 1){

            indAutobus = 0;

            printf("Vozilo %ld tipa AUTOBUS je preslo nadvoznjak sa %s strane\n", id, mojSmer ? "severne" : "juzne");

        } else if(tipVozila == 2){

            indKamion = 0;

            printf("Vozilo %ld tipa KAMION je preslo nadvoznjak sa %s strane\n", id, mojSmer ? "severne" : "juzne");

        } else {
            
            printf("DOSLO JE DO GRESKE (EXIT)\n");
            
            pthread_mutex_unlock(&mutexMost);
            
            return NULL;

        }

        if(brojVozilaNaMostu == 0){
            smerNaMostu = -1;
        }

        pthread_cond_broadcast(&condMost);
    }
    pthread_mutex_unlock(&mutexMost);

    return NULL;
}

int main(){
    pthread_t vozila[N_VOZILA];

    for(long i = 0 ; i < N_VOZILA; i++){
        pthread_create(&vozila[i], NULL, prelazak, (void *) i);
    }

    for(long i = 0 ; i < N_VOZILA; i++){
        pthread_join(vozila[i], NULL);
    }
    
    printf("SVA VOZILA SU USPESNO PRESLA NADVOZNJAK\n");

    return 0;
}